const apiBase = '/api/index.php/';

const path = window.location.pathname;

if (path.endsWith('index.html') || path === '/' || path === '') {
  const loginForm = document.getElementById('loginForm');
  if (loginForm) {
    loginForm.addEventListener('submit', function(e) {
      e.preventDefault();
      const username = document.getElementById('username').value;
      const password = document.getElementById('password').value;
      fetch(apiBase + 'login', {
        method: 'POST',
    headers: {'Content-Type': 'application/json'},
        body: JSON.stringify({username, password})
      }).then(res => res.json()).then(data => {
        if (data.token) {
          localStorage.setItem('token', data.token);
          localStorage.setItem('role', data.role);
          if (data.role === 'admin') {
            window.location.href = 'admin.html';
          } else {
            window.location.href = 'dashboard.html';
          }
        } else {
          alert(data.message || 'Erro no login');
        }
      }).catch(err => alert('Erro: ' + err));
    });
  }
}

if (path.endsWith('dashboard.html')) {
  const token = localStorage.getItem('token');
  if (!token) {
    window.location.href = 'index.html';
  }
  fetch(apiBase + 'point', {
    method: 'GET',
    headers: {'Authorization': 'Bearer ' + token}
  }).then(res => res.json()).then(points => {
    const list = document.getElementById('pointsList');
    if (list) {
      points.forEach(p => {
        const tr = document.createElement('tr');
        tr.innerHTML = `&lt;td&gt;${p.timestamp}&lt;/td&gt;&lt;td&gt;${p.type}&lt;/td&gt;`;
        list.appendChild(tr);
      });
    }
  }).catch(err => alert('Erro ao carregar pontos: ' + err));

  const entryBtn = document.getElementById('entryBtn');
  if (entryBtn) entryBtn.addEventListener('click', () => registerPoint('entry'));

  const exitBtn = document.getElementById('exitBtn');
  if (exitBtn) exitBtn.addEventListener('click', () => registerPoint('exit'));

  function registerPoint(type) {
    fetch(apiBase + 'point', {
      method: 'POST',
      headers: {'Content-Type': 'application/json', 'Authorization': 'Bearer ' + token},
      body: JSON.stringify({type})
    }).then(res => res.json()).then(data => {
      alert(data.message);
      location.reload();
    }).catch(err => alert('Erro: ' + err));
  }
}

if (path.endsWith('admin.html')) {
  const token = localStorage.getItem('token');
  if (!token || localStorage.getItem('role') !== 'admin') {
    window.location.href = 'index.html';
  }
  fetch(apiBase + 'user', {
    method: 'GET',
    headers: {'Authorization': 'Bearer ' + token}
  }).then(res => res.json()).then(users => {
    const list = document.getElementById('usersList');
    if (list) {
      users.forEach(u => {
        const tr = document.createElement('tr');
        tr.innerHTML = `&lt;td&gt;${u.username}&lt;/td&gt;&lt;td&gt;${u.role}&lt;/td&gt;&lt;td&gt;
          &lt;button onclick="updateRole(${u.id}, 'user')"&gt;Definir User&lt;/button&gt;
          &lt;button onclick="updateRole(${u.id}, 'admin')"&gt;Definir Admin&lt;/button&gt;
          &lt;button onclick="deleteUser(${u.id})"&gt;Deletar&lt;/button&gt;
        &lt;/td&gt;`;
        list.appendChild(tr);
      });
    }
  }).catch(err => alert('Erro ao carregar usuários: ' + err));

  const registerForm = document.getElementById('registerForm');
  if (registerForm) {
    registerForm.addEventListener('submit', function(e) {
      e.preventDefault();
      const username = document.getElementById('newUsername').value;
      const password = document.getElementById('newPassword').value;
      const role = document.getElementById('newRole').value;
      fetch(apiBase + 'register', {
        method: 'POST',
        headers: {'Content-Type': 'application/json', 'Authorization': 'Bearer ' + token},
        body: JSON.stringify({username, password, role})
      }).then(res => res.json()).then(data => {
        alert(data.message);
        location.reload();
      }).catch(err => alert('Erro: ' + err));
    });
  }

  const generateReport = document.getElementById('generateReport');
  if (generateReport) {
    generateReport.addEventListener('click', () => {
      const start = document.getElementById('start').value;
      const end = document.getElementById('end').value;
      const userId = document.getElementById('userId').value;
      let url = apiBase + 'report?start=' + start + '&end=' + end;
      if (userId) url += '&amp;user_id=' + userId;
      if (userId) url = apiBase + 'report?start=' + start + '&end=' + end + '&user_id=' + userId;
      fetch(url, {
        method: 'GET',
        headers: {'Authorization': 'Bearer ' + token}
      }).then(res => res.json()).then(reports => {
        const table = document.getElementById('reportTable');
        table.innerHTML = '';
        reports.forEach(r => {
          const tr = document.createElement('tr');
          tr.innerHTML = `&lt;td&gt;${r.username}&lt;/td&gt;&lt;td&gt;${r.timestamp}&lt;/td&gt;&lt;td&gt;${r.type}&lt;/td&gt;`;
          table.appendChild(tr);
        });
        document.getElementById('exportCSV').style.display = 'block';
      }).catch(err => alert('Erro ao gerar relatório: ' + err));
    });
  }

  const exportCSV = document.getElementById('exportCSV');
  if (exportCSV) {
    exportCSV.addEventListener('click', () => {
      const table = document.getElementById('reportTable');
      let csv = [];
      for (let i = 0; i < table.rows.length; i++) {
        let row = [], cols = table.rows[i];
        for (let j = 0; j < cols.cells.length; j++) {
          row.push(cols.cells[j].innerText);
        }
        csv.push(row.join(','));
      }
      const csvFile = new Blob([csv.join('\n')], {type: 'text/csv'});
      const downloadLink = document.createElement('a');
      downloadLink.download = 'relatorio.csv';
      downloadLink.href = window.URL.createObjectURL(csvFile);
      downloadLink.style.display = 'none';
      document.body.appendChild(downloadLink);
      downloadLink.click();
      document.body.removeChild(downloadLink);
    });
  }

  window.updateRole = function(id, role) {
    fetch(apiBase + 'user', {
      method: 'PUT',
      headers: {'Content-Type': 'application/json', 'Authorization': 'Bearer ' + token},
      body: JSON.stringify({id, role})
    }).then(res => res.json()).then(data => {
      alert(data.message);
      location.reload();
    }).catch(err => alert('Erro: ' + err));
  }

  window.deleteUser = function(id) {
    if (confirm('Confirmar deleção do usuário?')) {
    fetch(apiBase + 'user', {
      method: 'DELETE',
      headers: {'Content-Type': 'application/json', 'Authorization': 'Bearer ' + token},
      body: JSON.stringify({id})
      }).then(res => res.json()).then(data => {
        alert(data.message);
        location.reload();
      }).catch(err => alert('Erro: ' + err));
    }
  }
}