<?php

require_once __DIR__ . '/jwt.php';
$cfg = require __DIR__ . '/../config/config.php';

function getAuthHeader() {
  $headers = function_exists('getallheaders') ? getallheaders() : [];
  if (isset($headers['Authorization'])) return $headers['Authorization'];
  if (isset($_SERVER['HTTP_AUTHORIZATION'])) return $_SERVER['HTTP_AUTHORIZATION'];
  return null;
}

function verifyToken() {
  $auth = getAuthHeader();
  if (!$auth) {
    http_response_code(401);
    echo json_encode(['message' => 'Authorization header not provided']);
    exit;
  }
  // Accept both "Bearer <token>" and raw token
  if (stripos($auth, 'Bearer ') === 0) {
    $token = trim(substr($auth, 7));
  } else {
    $token = trim($auth);
  }
  $secret = $cfg['jwt_secret'] ?? 'replace_this_with_a_long_random_secret';
  $payload = jwt_decode($token, $secret);
  if (!$payload) {
    http_response_code(401);
    echo json_encode(['message' => 'Invalid or expired token']);
    exit;
  }
  return ['id' => $payload['sub'] ?? $payload['user_id'] ?? null, 'role' => $payload['role'] ?? 'user'];
}

?>