&lt;?php

require_once 'utils.php';

$user = verifyToken();

if ($method === 'POST') {
  $type = $data['type'] ?? 'entry';
  if (!in_array($type, ['entry', 'exit'])) {
    http_response_code(400);
    echo json_encode(['message' => 'Tipo inválido']);
    exit;
  }
  $timestamp = date('Y-m-d H:i:s');
  $pdo = getDB();
  $stmt = $pdo->prepare("INSERT INTO points (user_id, timestamp, type) VALUES (?, ?, ?)");
  $stmt->execute([$user['id'], $timestamp, $type]);
  echo json_encode(['message' => 'Ponto registrado com sucesso']);
} elseif ($method === 'GET') {
  $pdo = getDB();
  $stmt = $pdo->prepare("SELECT timestamp, type FROM points WHERE user_id = ? ORDER BY timestamp DESC");
  $stmt->execute([$user['id']]);
  $points = $stmt->fetchAll(PDO::FETCH_ASSOC);
  echo json_encode($points);
}

?&gt;