<?php

require_once __DIR__ . '/jwt.php';
$cfg = require __DIR__ . '/../config/config.php';

if ($endpoint === 'login' && $method === 'POST') {
  $username = trim($data['username'] ?? '');
  $password = $data['password'] ?? '';
  if (!$username || !$password) {
    http_response_code(400);
    echo json_encode(['message' => 'username and password required']);
    exit;
  }
  $pdo = getDB();
  $stmt = $pdo->prepare("SELECT * FROM users WHERE username = ?");
  $stmt->execute([$username]);
  $user = $stmt->fetch();
  if ($user && password_verify($password, $user['password'])) {
    $secret = $cfg['jwt_secret'] ?? 'replace_this_with_a_long_random_secret';
    $payload = [
      'sub' => $user['id'],
      'username' => $user['username'],
      'role' => $user['role']
    ];
    $token = jwt_encode($payload, $secret, $cfg['jwt_exp'] ?? 3600);
    echo json_encode(['token' => $token, 'role' => $user['role']]);
  } else {
    http_response_code(401);
    echo json_encode(['message' => 'Credenciais inválidas']);
  }
} elseif ($endpoint === 'register' && $method === 'POST') {
  // For production add admin check
  $username = trim($data['username'] ?? '');
  $plain = $data['password'] ?? '';
  $role = $data['role'] ?? 'user';
  if (!$username || !$plain) {
    http_response_code(400);
    echo json_encode(['message' => 'username and password required']);
    exit;
  }
  $password = password_hash($plain, PASSWORD_DEFAULT);
  $pdo = getDB();
  $stmt = $pdo->prepare("INSERT INTO users (username, password, role) VALUES (?, ?, ?)");
  try {
    $stmt->execute([$username, $password, $role]);
    echo json_encode(['message' => 'Usuário criado com sucesso']);
  } catch (PDOException $e) {
    http_response_code(400);
    echo json_encode(['message' => 'Erro ao criar usuário: ' . $e->getMessage()]);
  }
}

?>