# Sistema de Controle de Ponto e Frequência (Melhorado)

Resumo rápido:
- Frontend: HTML, CSS, JavaScript (Bootstrap incluido via CDN)
- Backend: PHP (sem dependência Composer para JWT - implementado localmente em `api/jwt.php`)
- Banco: MySQL (schema em `db/schema.sql`)

Passos para rodar localmente:
1. Configure as credenciais em `config/config.php` (host, name, user, pass, jwt_secret).
2. Crie o banco executando `db/schema.sql` (use seu cliente MySQL):
   - No terminal mysql: `mysql -u root -p < db/schema.sql`
3. Crie o usuário admin inicial (opcional) rodando:
   ```powershell
   php db/seed.php
   ```
4. Rode o servidor embutido PHP (PowerShell):
   ```powershell
   php -S localhost:8000 -t public
   ```
5. Acesse: `http://localhost:8000/index.html`

Notas importantes:
- JWT: Implementado em `api/jwt.php`. Substitua `jwt_secret` em `config/config.php` por uma string longa aleatória.
- Composer: opcional. Se você quiser migrar para bibliotecas oficiais (Slim, firebase/php-jwt), instale Composer e atualize `composer.json`.
- Segurança: para produção, sirva via Nginx/Apache, use HTTPS e proteja `config/config.php`.

Próximos passos recomendados:
- Migrar para JWT via `firebase/php-jwt` com Composer.
- Usar environment variables (.env) e não commitar segredos.
- Adicionar testes automatizados e CI.

